<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Install
{

    protected $_db;

    protected function _getDb()
    {
        if ($this->_db === null)
        {
            $this->_db = XenForo_Application::getDb();
        }

        return $this->_db;
    }
    
    public static function install($existingAddOn, $addOnData)
    {
        $install = new self();
        
        if (!$existingAddOn)
        {
            return $install->_installClean();
        }
        
        if ($existingAddOn['version_string'] == $addOnData['version_string'])
        {
            return;
        }
        
        switch ($existingAddOn['version_string'])
        {
        	case '1.1.13':
        		$install->_install_120();
        		break;
            case '1.1.12':
            case '1.1.11':
            case '1.1.10':
            case '1.1.9':
            case '1.1.8':
                $install->_install_113();
        		$install->_install_120();
                break;
            case '1.1.7':
            case '1.1.6':
            case '1.1.5':
            case '1.1.4':
            case '1.1.3':
            case '1.1.2':
            case '1.1.1':
            case '1.1.0':
            case '1.0.0':
                self::uninstall($existingAddOn);
                $install->_installClean();
                break;
        }
    }
    
    protected function _install_113()
    {
        $sql1 = "ALTER TABLE  `xf_sonnb_stop_spam_log` CHANGE  `ip`  `ip` varchar( 39 ) COLLATE utf8_bin NULL DEFAULT  '0'";
        $sql2 = "ALTER TABLE  `xf_sonnb_stop_spam_log` CHANGE  `content_type`  `content_type` varchar(20) COLLATE utf8_bin NOT NULL";
        $sql3 = "ALTER TABLE  `xf_sonnb_stop_spam_log` CHANGE  `log_type`  `log_type` varchar(20) COLLATE utf8_bin NOT NULL";
        $sql4 = "ALTER TABLE  `xf_sonnb_stop_spam_log` CHANGE  `action`  `action` varchar(20) COLLATE utf8_bin NOT NULL";
        
        $this->_getDb()->query($sql1);
        $this->_getDb()->query($sql2);
        $this->_getDb()->query($sql3);
        $this->_getDb()->query($sql4);
    }
    
    protected function _install_120()
    {
    	$sql1 = "ALTER TABLE  `xf_sonnb_stop_spam_log` CHANGE  `content_type`  `content_type` varchar(20) COLLATE utf8_bin NOT NULL";
    	
    	$this->_getDb()->query($sql1);
    }

    protected function _installClean()
    {
        $sql = "CREATE TABLE `xf_sonnb_stop_spam_log` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `username` varchar(50) COLLATE utf8_bin NOT NULL,
            `email` varchar(100) COLLATE utf8_bin NOT NULL,
            `ip` varchar(39) COLLATE utf8_bin NOT NULL,
            `user_id` int(11) NOT NULL DEFAULT '0',
            `time` int(10) NOT NULL,
            `content_type` varchar(20) COLLATE utf8_bin NOT NULL,
            `content_id` int(11) unsigned NOT NULL,
            `log_type` varchar(20) COLLATE utf8_bin NOT NULL,
            `data` blob NOT NULL,
            `action` varchar(20) COLLATE utf8_bin NOT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;";
        
        $this->_getDb()->query($sql);
    }

    public static function uninstall($existingAddOn)
    {
        if (empty($existingAddOn))
        {
            return;
        }
        
        $uninstall = new self();
        
        $sql = 'DROP TABLE IF EXISTS `xf_sonnb_stop_spam_log`;';

        $uninstall->_getDb()->query($sql);
    }

}